# -*- coding: UTF-8 -*-
TYPE_TO_SNS_MAPPING = {
    "71": "SNS2124",
    "109": "SNS2248",
    "118": "SNS2224",
    "120": "SNS5384",
    "121": "SNS5192",
    "133": "SNS3096",
    "162": "SNS3664",
    "183": "SNS3664",
    "165": "SNS5604",
    "166": "SNS5608",
    "170": "SNS2624",
    "173": "SNS3696E",
    "184": "SNS3696E",
    "181": "SNS3764"
}

# "SNS5604/SNS5608/SNS5704/SNS5708" 需要获取新的sn: Chassis Factory Serial Num
NEED_USE_CHASSIS_FACTORY_SN_TYPE = ["165", "166"]


def execute(context):
    """
    Function name      : execute
    Function describe  : 获取交换机信息
    Input              : context
    """

    global CLI
    CLI = context.get("SSH")

    switchName, switchType, serialNumber = getSwitchInfo()
    version = getSwitchVersion()
    sn = get_switch_sn(CLI, serialNumber, switchType)

    switchType = TYPE_TO_SNS_MAPPING.get(switchType, switchType)

    return {"name": switchName, "type":switchType, "sn": sn, "version": version}


def get_switch_sn(cli, default_sn, switch_type):
    """
    1. "SNS5604/SNS5608/SNS5704/SNS5708" 需要获取新的sn: Chassis Factory Serial Num
    2. 默认优先使用Factory Serial Num
    :param cli: ssh 连接
    :param default_sn: 默认 switchWwn
    :param switch_type: 类型
    :return: sn
    """
    cli_ret = cli.execCmdWithTimout("chassisshow", 60)
    factory_sn = get_factory_sn(cli_ret)
    if switch_type in NEED_USE_CHASSIS_FACTORY_SN_TYPE:
        chassis_factory_sn = get_chassis_factory_sn(cli_ret)
        if chassis_factory_sn:
            return chassis_factory_sn
    if factory_sn:
        return factory_sn

    return default_sn


def get_chassis_factory_sn(cli_ret):
    """
    获取部分机型的 chassis factory sn
    :param cli_ret: 回文
    :return: chassis factory sn
    """
    lines = cli_ret.splitlines()
    for line in lines:
        if "Chassis Factory Serial Num:" in line:
            return line.split("Chassis Factory Serial Num:")[1].strip()
    return ""


def get_factory_sn(cli_ret):
    """
    获取部分中低端机型的sn factory serial num
    :param cli_ret: 回文
    :return: factory sn
    """
    key_list = ["CHASSIS/WWN  Unit: 1", "WWN  Unit: 1"]
    for key in key_list:
        if key not in cli_ret:
            continue
        tmp_ret = cli_ret[cli_ret.index(key):]
        tmp_list = tmp_ret.splitlines()
        for line in tmp_list:
            if "Factory Serial Num" not in line:
                continue
            tmp_sn_list = line.split(":")
            if len(tmp_sn_list) == 2:
                return tmp_sn_list[1].strip()


def getSwitchInfo():
    '''
    @summary: 获取交换机类型, SN
    @return: switchType, switchWwn
    '''
    cliRet = CLI.execCmdWithTimout("switchshow", 60)
    cliRetList = cliRet.splitlines()

    switchType = ''
    switchWwn = ''
    switchName = ''
    for line in cliRetList:
        if line.startswith("switchName:"):
            switchName = line.split(":")[-1].strip()
            continue
        if line.startswith("switchType:"):
            switchType = line.split(":")[-1].strip().split(".")[0]
            continue
        if line.startswith("switchWwn:"):
            switchWwn = line[line.index(":") + 1:].strip().replace(":", "")
        if switchType and switchWwn:
            break
    return switchName, switchType, switchWwn

def getSwitchVersion():
    '''
    @summary: 获取交换机版本号
    @return: switchVersion
    '''

    cliRet = CLI.execCmdWithTimout("version", 60)
    cliRetList = cliRet.splitlines()

    switchVersion = ''
    for line in cliRetList:
        if line.startswith("Fabric OS:"):
            switchVersion = line.split(":")[-1].strip()
            break
    return switchVersion
